package org.msh.tb.bd.tbforms.dhis2.tb10.blockbuilders;

import org.msh.tb.bd.tbforms.dhis2.TBFormBlockBuilder;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block2Query;
import org.msh.tb.entities.FieldValue;

/**
 * Created by Mauricio on 17/02/2017.
 * Query database and mount TB Form 10 Block 2 Payload to be sent to DHIS2 APIs
 */
public class TBForm10Block2Builder extends TBFormBlockBuilder {

    private TBForm10Block2Query formQuery;

    @Override
    protected void loadAllFieldsAsZero(DataValuePayload payload) {
        for (DataElementTB10Block2 de : DataElementTB10Block2.values()) {
            payload.mergeDataValue(de.dhis2DataElementId, null, new Long(0));
        }
    }

    @Override
    protected TBForm10Block2Query getBlockQuery() {
        if (formQuery == null) {
            formQuery = new TBForm10Block2Query();
        }

        return formQuery;
    }

    @Override
    protected void mountResultPayload(Object[] result, DataValuePayload payload) {
        String patientRefTo = (String)result[0];
        Long count = (Long) result[2];

        // find the DHIS2 data element and category id
        String dataElementId = DataElementTB10Block2.findId(patientRefTo);

        // merge payload result
        payload.mergeDataValue(dataElementId, null, count);
    }

    /**
     * Catalog that holds the ids of DHIS2 data element used by TB 10 Form Block 2
     */
    public enum DataElementTB10Block2 {

        PP_GRADUATE("pGraduatePract", "iZDEA13Ou8S"),
        NON_GRADUATE_PP("NonpGraduatePract", "pEwtyrA7POX"),
        GFS("GovFieldStaff", "IWn25lyR94c"),
        SS_NGFS("ShasthoShebika", "YVXZRUVAcL4"),
        VD("VillageDoctor", "ufwPqzCdpIo"),
        CV("CommVolunteer", "VwCj2Hmbq4I"),
        GOVT_HOSPITAL("GovtHospital", "WddfVKVhOwO"),
        PRIVATE_HOSPITAL("PrivateHospital", "BiFD6r9yQeY"),
        CHCP("CHCP", "cecgHhpy4D5"),
        TB_PATIENT("TBPatient", "KulXrgtMWwI"),
        OTHERS("Other", "Mvn3n9EsQmv");

        DataElementTB10Block2(String etbmCustomIdReferredBy, String dhis2DataElementId) {
            this.etbmCustomIdReferredBy = etbmCustomIdReferredBy;
            this.dhis2DataElementId = dhis2DataElementId;
        }

        /**
         * Referred By field value custom id
         */
        private String etbmCustomIdReferredBy;

        /**
         * Corresponding TB Form 10 Block 2 Data Element Id.
         */
        private String dhis2DataElementId;

        /**
         * Returns the DHIS2 dataElement id that matches with the params.
         * @param etbmCustomIdReferredBy
         * @return
         */
        public static String findId(String etbmCustomIdReferredBy) {
            // find the id
            if(etbmCustomIdReferredBy == null) {
                throw new RuntimeException("Referred By Id must not be null");
            }

            for(DataElementTB10Block2 elem : values()) {
                if (elem.etbmCustomIdReferredBy.equals(etbmCustomIdReferredBy)) {
                    return elem.dhis2DataElementId;
                }
            }

            throw new RuntimeException("TB10Block2DataElement: Data element not found");
        }

        public String getDhis2DataElementId() {
            return dhis2DataElementId;
        }
    }
}
